
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP | CLK_FILTER_LINEAR;
#define ChannelBlend_Exclusion(B,L)  ((B + L - ((B * L)*2.0f)))

static vec4 INPUT(image2d_t src_data, vec2 tc, __global FilterParam* param)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc ).zyxw;
}

vec3 AdjustforJigsaw_PurpleGreen(vec3 rgb)
{
	vec3 output; 
	output.x = ChannelBlend_Exclusion(58.0f/256.0f, rgb.x );
	output.y = ChannelBlend_Exclusion(15.0f/256.0f, rgb.y);
	output.z = ChannelBlend_Exclusion(34.0f/256.0f, rgb.z);
	return output; 
}

vec3 AdjustforJigsaw_BrownGray(vec3 rgb)
{
	vec3 output; 
	output.x = ChannelBlend_Exclusion(21.0f/256.0f, rgb.x);
	output.y = ChannelBlend_Exclusion(59.0f/256.0f, rgb.y);
	output.z = ChannelBlend_Exclusion(79.0f/256.0f, rgb.z);
	return output; 
}

vec3 AdjustforJigsaw_BrownGreen(vec3 rgb)
{
	vec3 output; 
	output.x= ChannelBlend_Exclusion(14.0f/256.0f, rgb.x);
	output.y = ChannelBlend_Exclusion(24.0f/256.0f, rgb.y);
	output.z = ChannelBlend_Exclusion(63.0f/256.0f, rgb.z);
	return output; 
}

vec3 AdjustforJigsaw_BlueGreen(vec3 rgb)
{
	vec3 output; 
	output.x = ChannelBlend_Exclusion(75.0f/256.0f, rgb.x);
	output.y = ChannelBlend_Exclusion(46.0f/256.0f, rgb.y);
	output.z = ChannelBlend_Exclusion(17.0f/256.0f, rgb.z);
	return output; 
}

__kernel  void MAIN(
      __read_only image2d_t src_data,
      __write_only image2d_t dest_data,        //Data in global memory
	  __global FilterParam* param,
	  int alpha) // alpah 0 - 100
{	
	int W = get_global_size(0);
	int H = get_global_size(1);
	int w = get_global_id0( param);
	int h = get_global_id1( param);
	float2 resolution = (float2)(W,H);
	float2 iResolution = resolution;
	int2 coordinate = (int2)(get_global_id0( param), get_global_id1( param));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 uv = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f)) /resolution.xy;
	vec2 tc = uv;

	// Get the images
	vec4 col;
	vec4 inColor = INPUT( src_data, (vec2)(tc.x, tc.y), param);
	float whiteGap = 0.00625f/2.0f;
	float colorGapX = 0.496875f;
	float whiteGapY = whiteGap*W*1.0/H;
	float colorGapY = (1.0f - whiteGapY)/2.0f;
	
	uv = (float2)(tc.x, 1.0f - tc.y);
	if( uv.x<colorGapX && uv.y< colorGapY )
		col.xyz = AdjustforJigsaw_PurpleGreen(inColor.xyz); 
	else if( uv.x > colorGapX+whiteGap && uv.y< colorGapY )
		col.xyz = AdjustforJigsaw_BrownGreen(inColor.xyz); 
	else if ( uv.x<colorGapX && uv.y > colorGapY + whiteGapY )
		col.xyz = AdjustforJigsaw_BrownGray(inColor.xyz); 
	else if ( uv.x > colorGapX + whiteGap  && uv.y > colorGapY + whiteGapY )
		col.xyz = AdjustforJigsaw_BlueGreen(inColor.xyz); 
	else col.xyz = (vec3)(0.0f);
	col.w = inColor.w;
	
	write_imagef(dest_data, (int2)(get_global_id(0), get_global_id(1)), inColor.zyxw*(1.0f - alpha/100.0f) + col.zyxw*alpha/100.0f);
}

